% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_peak.R
\name{estimate_peak}
\alias{estimate_peak}
\title{Estimate the peak date of an incidence curve using bootstrap}
\usage{
estimate_peak(x, n = 100, alpha = 0.05, progress = TRUE)
}
\arguments{
\item{x}{An \link[incidence2:incidence]{incidence2::incidence} object.}

\item{n}{The number of bootstrap datasets to be generated; defaults to 100.}

\item{alpha}{The type 1 error chosen for the confidence interval; defaults to
0.05.}

\item{progress}{Should a progress bar be displayed (default = TRUE)}
}
\value{
A tibble with the the following columns:
\itemize{
\item \code{observed_date}: the date of peak incidence of the original dataset.
\item \code{observed_count}: the peak incidence of the original dataset.
\item \code{estimated}: the mean peak time of the bootstrap datasets.
\item \code{lower_ci/upper_ci}: the confidence interval based on bootstrap datasets.
\item \code{peaks}: a nested tibble containing the the peak times of the bootstrapped
datasets.
}
}
\description{
This function can be used to estimate the peak of an epidemic curve stored as
\link[incidence2:incidence]{incidence2::incidence} object, using bootstrap. See \code{\link[=bootstrap]{bootstrap()}} for more
information on the resampling.
}
\details{
Input dates are resampled with replacement to form bootstrapped
datasets; the peak is reported for each, resulting in a distribution of
peak times. When there are ties for peak incidence, only the first date is
reported.

Note that the bootstrapping approach used for estimating the peak time makes
the following assumptions:
\itemize{
\item the total number of event is known (no uncertainty on total incidence)
\item dates with no events (zero incidence) will never be in bootstrapped
datasets
\item the reporting is assumed to be constant over time, i.e. every case is
equally likely to be reported
}
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE) &&
    requireNamespace("incidence2", quietly = TRUE)) {
  withAutoprint( {
    # load data and create incidence
    data(fluH7N9_china_2013, package = "outbreaks")
    i <- incidence2::incidence(fluH7N9_china_2013, date_index = date_of_onset)
    i

    # one simple bootstrap
    x <- bootstrap(i)
    x

    # find 95\% CI for peak time using bootstrap
    peak_data <- estimate_peak(i)
    peak_data
    summary(peak_data$peaks)
  })
}

}
\seealso{
\code{\link[=bootstrap]{bootstrap()}} for the bootstrapping underlying this
approach and \code{\link[=find_peak]{find_peak()}} to find the peak in a single
\link[incidence2:incidence]{incidence2::incidence} object.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}, with inputs on
caveats from Michael Höhle.
}
