% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{color_biplot_by_discrete}
\alias{color_biplot_by_discrete}
\title{Colors a biplot according to a vector with discrete values}
\usage{
color_biplot_by_discrete(matrix, discrete_vector, ..., bty = "l", pch = 16,
  cex = 0.5, colors = NULL)
}
\arguments{
\item{matrix}{a two columns matrix}

\item{discrete_vector}{a vector of size nrow(matrix)}

\item{...}{passed to plot}

\item{bty}{passed to plot}

\item{pch}{passed to plot}

\item{cex}{passed to plot}

\item{colors}{Palette to used named after the unique elements of discrete_vector. Generated from rainbow() if missing.}
}
\description{
Colors a biplot according to a vector with discrete values
}
\examples{
data(Samusik_01_subset)
levels=unique(sort(Samusik_01_subset$labels))
colors=setNames(colorRampPalette(palette())(length(levels)),sort(levels))
with(Samusik_01_subset,color_biplot_by_discrete(matrix=tsne,discrete_vector=labels,colors=colors))
}
