% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypercube-package.R
\docType{package}
\name{hypercube-package}
\alias{hypercube-package}
\alias{hypercube}
\title{Provides methods for organizing data in a hypercube}
\description{
This package provides methods for organizing data in a hypercube
Each cube can be manipulated with five operations rotation (changeDimensionOrder),
dicing and slicing (add.selection, remove.selection), drilling down (add.aggregation),
and rolling up (remove.aggregation).
}
\details{
\tabular{ll}{ Package: \tab hypercube\cr Type: \tab Package\cr Version:
\tab 0.2.0\cr Date: \tab 2019-09-18\cr License: \tab GPL-3\cr Depends: \tab
R (>= 3.0), methods\cr }
}
\examples{

# Simple example
data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube

# More sophisticated example
data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
       location = c("state"), product = "product"), valueColumn = "amount")
cube = add.selection(cube, criteria = list(state = c("AL", "TX")))
cube = add.aggregation(cube, dimensions = c("month", "year"), fun = "sum")
cube
df = as.data.frame(cube)
df
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\concept{hypercube}
\keyword{manip}
