% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{changeDimensionOrder}
\alias{changeDimensionOrder}
\title{Changes the order of the dimensions in a given cube}
\usage{
changeDimensionOrder(cube, dimensions)
}
\arguments{
\item{cube}{Hypercube for which the dimension should be re-ordered.}

\item{dimensions}{Vector of dimensions. The order of the dimensions in this vector defines the order of the dimensions in the cube.}
}
\value{
Returns a \code{Cube} object.
}
\description{
Changes the order of the dimensions in a given cube
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube = changeDimensionOrder(cube, dimensions = c("product", "month", "year", "state"))
cube

}
\seealso{
\code{\link[=Cube-class]{Cube}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
