% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_points_to_lines.R
\name{index_points_to_waterbodies}
\alias{index_points_to_waterbodies}
\title{Index Points to Waterbodies}
\usage{
index_points_to_waterbodies(
  waterbodies,
  points,
  flines = NULL,
  search_radius = NULL
)
}
\arguments{
\item{waterbodies}{sf data.frame of type POLYGON or MULTIPOLYGON including
a "wbid" attribute.}

\item{points}{sfc of type POINT}

\item{flines}{sf data.frame (optional) of type LINESTRING or MULTILINESTRING including
id, wbid, and topo_sort attributes. If omitted, only waterbody indexes are returned.}

\item{search_radius}{units class with a numeric value indicating how far to
search for a waterbody boundary in units of provided projection. Set units with
\link[units]{set_units}.}
}
\value{
data.frame with columns \code{in_wb_COMID} (or \code{in_wbid}), \code{near_wb_COMID}
(or \code{near_wbid}), \code{near_wb_dist}, and \code{outlet_fline_COMID} (or \code{wb_outlet_id}).
Column names use COMID when input contains a COMID attribute, otherwise
hydroloom names (wbid) are used.
Distance is in units of provided projection.
}
\description{
given an sf point geometry column, return waterbody id, and
id of dominant artificial path
}
\examples{

if (require(nhdplusTools)) {

  source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

  waterbodies <- sf::st_transform(
    sf::read_sf(sample_data, "NHDWaterbody"), 5070)

  points <- sf::st_transform(
    sf::st_sfc(sf::st_point(c(-89.356086, 43.079943)),
      crs = 4326), 5070)

  index_points_to_waterbodies(waterbodies, points,
    search_radius = units::set_units(500, "m"))

}

}
