% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{flow_max_freeboard}
\alias{flow_max_freeboard}
\alias{flow_max_freeboard,CSarbitrary-method}
\title{Maximum Flow Including Freeboard}
\usage{
flow_max_freeboard(object, J, type = "KOHS", sigma_wz = 0, fw = TRUE, fv = FALSE, ft = 0,
fe = NULL, fe_min = 0, fe_max = Inf, method = "Strickler",
ret = "all", plot = FALSE)
}
\arguments{
\item{object}{A CSarbitrary object.}

\item{J}{Bottom slope [-].}

\item{type}{Type of freeboard calculation. Defaults to "KOHS".}

\item{sigma_wz}{Uncertainty in bed elevation (morphodynamics) [m].}

\item{fw}{Logical; considers freeboard due to uncertainty in water elevation.
If TRUE, calculates according to KOHS; if FALSE, sets fw = 0.}

\item{fv}{Logical; considers freeboard due to waves. If `TRUE`, calculates
according to KOHS; if FALSE, sets fv = 0.}

\item{ft}{Freeboard due to driftwood based on KOHS (2013) [m].}

\item{fe}{Fixed freeboard value to override calculations [m].}

\item{fe_min}{Minimum freeboard [m].}

\item{fe_max}{Maximum freeboard [m].}

\item{method}{Method to calculate the roughness. Allowed are "Strickler"
(equal roughness) and "Einstein" (mean roughness).}

\item{ret}{Definition of the result returned by the function ("all", "Qmax",
"hmax", "fe", or "v").}

\item{plot}{Logical; whether to plot the results.}
}
\value{
Depending on ret, returns flow, water level, velocity, or all
  details.
}
\description{
Calculates the maximum discharge of a CSarbitrary
object including a freebord for a given bottom slope under uniform flow conditions.
}
\examples{
# Cross section
x <- c(-0.85, 3, 15, 18.85)
z <- c(3.85, 0, 0, 3.85)
cs<- CSarbitrary(x = x, z = z, xb_l = 3, xb_r = 15,
                                      kSt_B = 45)

# Channel
flow_max_freeboard(cs, sigma_wz = 0.3, fv = FALSE, J = 2.2 * 10^-2)
# Dam
flow_max_freeboard(cs, sigma_wz = 0.3, fv = TRUE, J = 2.2 * 10^-2)
# Bridge
flow_max_freeboard(cs, sigma_wz = 0.3, fv = TRUE, ft = 0.5,
           J = 2.2 * 10^-2)

# Sensitivity analysis for slope
J <- seq(1, 3, 0.1) * 10^-2
Q <- sapply(J, function(J) {
  flow_max_freeboard(cs, sigma_wz = 0.3, fv = TRUE, ft = 0.5,
             J = J)$Qmax
})
plot(J, Q, type = "l")
}
\references{
KOHS (2013). Freibord bei Hochwasserschutzprojekten und
  Gefahrenbeurteilungen - Empfehlungen der Kommission Hochwasserschutz KOHS.
  Wasser Energie Luft 105(1): 43-53.
}
