% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{rbind.WaterLevelDataFrame}
\alias{rbind.WaterLevelDataFrame}
\title{Combine WaterLevelDataFrames by Rows}
\usage{
\method{rbind}{WaterLevelDataFrame}(...)
}
\arguments{
\item{\dots}{objects of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
All supplied objects of class \linkS4class{WaterLevelDataFrame} will
  be combined to one object of class \linkS4class{WaterLevelDataFrame} which
  is returned.
}
\description{
Take \linkS4class{WaterLevelDataFrame}s that were produced for 
  the same \code{river} and \code{time} and combine them by \code{r}ows.
}
\examples{
wldf1 <- WaterLevelDataFrame(river   = "Elbe",
                             time    = as.POSIXct("2016-12-21"),
                             station = seq(257, 262, 0.1))
wldf2 <- WaterLevelDataFrame(river = "Elbe",
                             time = as.POSIXct("2016-12-21"),
                             station = seq(262, 270, 0.1))
wldf <- rbind(wldf1, wldf2)

}
\seealso{
\code{\link[base:cbind]{rbind}}
}
