% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{[.WaterLevelDataFrame}
\alias{[.WaterLevelDataFrame}
\alias{[,WaterLevelDataFrame-method}
\alias{[,WaterLevelDataFrame,ANY,ANY-method}
\alias{[<-.WaterLevelDataFrame}
\alias{[<-,WaterLevelDataFrame-method}
\alias{[<-,WaterLevelDataFrame,ANY,ANY,data.frame-method}
\title{Extract or replace parts of a WaterLevelDataFrame}
\usage{
\S4method{[}{WaterLevelDataFrame}(x, i, j)

\S4method{[}{WaterLevelDataFrame,ANY,ANY,data.frame}(x, i, j) <- value
}
\arguments{
\item{x}{object of class \linkS4class{WaterLevelDataFrame}.}

\item{i, j}{elements to extract or replace. For \code{[}, these are 
\code{numeric} or \code{character} or empty. Numeric values are coerced to 
integer as if by \code{\link[base:integer]{as.integer}}. For replacement 
by \code{[}, a logical matrix is allowed.}

\item{value}{A suitable replacement value: it will be repeated a whole number
of times if necessary and it may be coerced: see the Coercion section. If 
\code{NULL}, deletes the column if a single column is selected.}
}
\value{
A new object of class \linkS4class{WaterLevelDataFrame} is returned. 
  Since the extraction or replacement acts only on the \code{.Data}-slot of 
  the object, all other slots remain unchanged.
}
\description{
Extract or replace subsets of the \code{.Data} slot of an object
  of class \linkS4class{WaterLevelDataFrame}.
}
\details{
For details see \code{\link[base:[.data.frame]{[.data.frame}}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- wldf[which(wldf$station >= 259 & wldf$station <= 261), ]

}
\seealso{
\code{\link[base:[.data.frame]{[.data.frame}}
}
