% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df.gauging_station_data}
\alias{df.gauging_station_data}
\title{Gauging station data for all WSV-run gauging stations along Elbe and Rhine}
\format{
A \code{data.frame} with 70 rows and 13 variables:
\describe{
\item{id}{continuous numbering (type \code{integer}).}
\item{gauging_station}{name of the gauging station (type \code{character}). It is used as JOIN field for dataset \code{\link{df.gauging_data}}.}
\item{uuid}{of the gauging station in the PEGELONLINE system (type \code{character}).}
\item{agency}{of the waterway and shipping administration in charge of the respective gauging station (type \code{character}).}
\item{km}{official stationing of the gauging station (type \code{numeric}).}
\item{longitude}{of the gauging stations location (WGS1984, type \code{numeric}).}
\item{latitude}{of the gauging stations location (WGS1984, type \code{numeric}).}
\item{mw}{mean water level of the gauging station (m relative to the gauge zero, type \code{numeric}).}
\item{mw_timespan}{timespan used to derive the gauging stations mean water level (type \code{character}).}
\item{pnp}{the gauge zero relative to sea level (NHN (DHHN92), type \code{numeric}).}
\item{data_present}{\code{logical} to separate TRUE (real) from section structuring FALSE gauging stations.}
\item{km_qps}{corrected stationing used for the water level computations of \code{\link{waterLevel}} and \code{\link{waterLevelPegelonline}} (type \code{numeric}).}
\item{river}{the gauging station is located on (type \code{character}).}
}
}
\usage{
df.gauging_station_data
}
\description{
This dataset contains gauging station data for the gauging
  stations along \strong{Elbe} and \strong{Rhine} operated by the waterway 
  and shipping administration (Wasserstraßen- und Schifffahrtsverwaltung 
  (WSV)). The data were originally obtained from 
  \url{https://pegelonline.wsv.de/gast/start} and are updated anually.
}
\references{
\insertRef{wsv_pegelonline_2018}{hyd1d}
}
\keyword{datasets}
