% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{bold}
\alias{bold}
\alias{bold<-}
\alias{set_bold}
\alias{italic}
\alias{italic<-}
\alias{set_italic}
\title{Cell text style}
\usage{
bold(ht)
bold(ht) <- value
set_bold(ht, row, col, value, byrow = FALSE)

italic(ht)
italic(ht) <- value
set_italic(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix Set to \code{NA} to reset to the default, which is
\code{FALSE}.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{bold}, the \code{bold} property.
For \code{set_bold}, the \code{ht} object.

Similarly for \code{italic} and friends.
}
\description{
Functions to get or set the \emph{cell text style} property of huxtable cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
bold(ht) <-  TRUE
bold(ht)
print_screen(ht)

ht <- huxtable(a = 1:3, b = 3:1)
set_bold(ht, TRUE)
set_bold(ht, 1:2, 1, TRUE)
set_bold(ht, 1:2, 1:2, c(TRUE, FALSE), byrow = TRUE)
set_bold(ht, where(ht == 1), TRUE)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{font_size}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
