% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation.R
\name{cbind.huxtable}
\alias{cbind.huxtable}
\alias{rbind.huxtable}
\title{Combine rows or columns}
\usage{
\method{cbind}{huxtable}(..., deparse.level = 1,
  copy_cell_props = TRUE)

\method{rbind}{huxtable}(..., deparse.level = 1,
  copy_cell_props = TRUE)
}
\arguments{
\item{...}{Vectors, matrices, data frames or huxtables.}

\item{deparse.level}{Unused.}

\item{copy_cell_props}{Cell properties to copy from neighbours (see below).}
}
\value{
A huxtable.
}
\description{
Combine rows or columns
}
\details{
Table properties will be taken from the first argument which is a huxtable. So will
row properties (for cbind) and column properties (for rbind).

If some of the inputs are not huxtables, and \code{copy_cell_props} is a character vector of cell
properties, then the named cell properties will be copied to non-huxtables. Objects on the left
or above get priority over those on the right or below. These properties may also include
\code{"row_height"} (for rbind) or \code{"col_width"} (for cbind). Numeric row heights and column widths
will be rescaled to 1.

If \code{copy_cell_props} is \code{TRUE}, the default set of cell properties (everything but \code{colspan} and
\code{rowspan}, including row heights/column widths) will be copied.

If \code{copy_cell_props} is \code{FALSE}, cells from non-huxtable objects will get the default properties.
}
\examples{
ht1 <- hux(a = 1:3, b = 4:6)
ht2 <- hux(d = letters[1:3], e = letters[4:6])
bold(ht1)[1,] <- TRUE
bold(ht2) <- TRUE
vec <- LETTERS[1:3]

ht_out <- cbind(ht1, vec, ht2)
ht_out
bold(ht_out)
bold(cbind(ht1, vec, ht2, copy_cell_props = FALSE))

}
