% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_outer_borders}
\alias{set_outer_borders}
\title{Set outer borders round a rectangle of cells}
\usage{
set_outer_borders(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable}

\item{row}{A set of rows. See below.}

\item{col}{A set of columns.}

\item{value}{A numeric value for the border width. Set to 0 for no border.}
}
\value{
The modified huxtable.
}
\description{
This is a convenience function to set a border round the top,
bottom, left and right of a group of cells.
}
\details{
Only standard R subsetting may be used for \code{row} and \code{col}. That is,
logical, numeric or character indices are allowed, but not the tricks in \code{\link{rowspecs}}.
}
\examples{
ht <- huxtable(a = 1:3, b = 1:3)
ht <- set_outer_borders(ht, 2:3, 1:2, 1)
ht
}
\seealso{
\code{\link{left_border}}, \code{\link{set_all_borders}}
}
