% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_first.R
\name{which_first}
\alias{which_first}
\title{Where does a logical expression first return \code{TRUE}?}
\usage{
which_first(expr, verbose = FALSE)
}
\arguments{
\item{expr}{An expression, such as \code{x == 2}.}

\item{verbose}{(logical, default: \code{FALSE}) If \code{TRUE} a message is emitted
if \code{expr} could not be handled in the advertised way.}
}
\value{
The same as \code{which.max(expr)} or \code{which(expr)[1]} but returns \code{0L}
when \code{expr} has no \code{TRUE} values.
}
\description{
A faster and safer version of \code{which.max} applied
to simple-to-parse logical expressions.
}
\details{
If the \code{expr} is of the form \code{LHS <operator> RHS}
and \code{LHS} is a single symbol, \code{operator} is one of
\code{==},  \code{!=}, \code{>}, \code{>=}, \code{<}, \code{<=},
or \code{\%in\%}.
and \code{RHS} is a single numeric value, then \code{expr} is not
evaluated directly; instead, each element of \code{LHS} is compared
individually.

If \code{expr} is not of the above form, then \code{expr} is evaluated
and passed to \code{which.max}.

Using this function can be significantly faster than the alternatives
when the computation
of \code{expr} would be expensive, though the difference is only likely to
be clear when \code{length(x)} is much larger than 10 million.
But even for smaller vectors, it has the benefit of returning
\code{0L} if none of the values in \code{expr} are \code{TRUE}, unlike
\code{which.max}.

Compared to \code{\link[base:funprog]{Position}} for an appropriate
choice of \code{f} the speed of \code{which_first} is not much faster
when the expression is \code{TRUE} for some position. However, \code{which_first}
is faster when all elements of \code{expr} are \code{FALSE}.
Thus \code{which_first} has a smaller worst-case time than the
alternatives for most \code{x}.
}
\examples{

N <- 1e5
# N <- 1e8  ## too slow for CRAN

# Two examples, from slowest to fastest,
# run with N = 1e8 elements

                                       # seconds
x <- rep_len(runif(1e4, 0, 6), N)
bench_system_time(x > 5)
bench_system_time(which(x > 5))        # 0.8
bench_system_time(which.max(x > 5))    # 0.3
bench_system_time(which_first(x > 5))  # 0.000

## Worst case: have to check all N elements
x <- double(N)
bench_system_time(x > 0)
bench_system_time(which(x > 0))        # 1.0
bench_system_time(which.max(x > 0))    # 0.4  but returns 1, not 0
bench_system_time(which_first(x > 0))  # 0.1

x <- as.character(x)
# bench_system_time(which(x == 5))     # 2.2
bench_system_time(which.max(x == 5))   # 1.6
bench_system_time(which_first(x == 5)) # 1.3

}
