% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_pattern_in.R
\name{replace_pattern_in}
\alias{replace_pattern_in}
\title{Replace string pattern in text file}
\usage{
replace_pattern_in(file_contents, replace, basedir = ".",
  dir_recursive = TRUE, reader = readLines,
  file_pattern = "\\\\.(R|r)(nw|md)?$", file_contents_perl = TRUE,
  file_contents_fixed = FALSE, file_contents_ignore_case = FALSE,
  writer = writeLines)
}
\arguments{
\item{file_contents}{Character string containing a regular expression to be matched in the 
given character vector. Passed to \code{pattern} in \code{\link[base]{gsub}}.}

\item{replace}{The replacement, passed to \code{replacement} in \code{\link[base]{gsub}}.}

\item{basedir}{The root of the directory tree in which files will be searched recursively.}

\item{dir_recursive}{(logical, default: \code{TRUE}) Search within subdirectories of \code{basedir}?}

\item{reader}{A function, akin to \code{base::readLines}, the default, that accepts a filename and returns a character vector.}

\item{file_pattern}{A regular expression passed to \code{list.files(pattern = file.ext)}.
By default, \code{"\\.(R|r)(nw|md)?$"}, i.e. all R and Sweave files. (Does not have to be a file extension.)}

\item{file_contents_perl}{(logical, default: \code{TRUE}) Should \code{file_contents} 
be interpreted as a \code{perl} regex?}

\item{file_contents_fixed}{(logical, default: \code{FALSE}) Should \code{file_contents} 
be interpreted as a \code{fixed} regex?}

\item{file_contents_ignore_case}{(logical, default: \code{FALSE}) As in \code{\link[base]{grep}}.}

\item{writer}{A function that will rewrite the file from the character vector read in.}
}
\description{
Replace string pattern in text file
}
