% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{WVP}
\alias{WVP}
\title{calculate partial water vapor pressure}
\usage{
WVP(psi, Es)
}
\arguments{
\item{psi}{relative humidity \eqn{\psi} in percentage (\eqn{\%})}

\item{Es}{saturation vapor pressure \eqn{e_s}(hPa) at temperature \eqn{t}, which can be calculated by callling \code{\link{SVP}} function.}
}
\value{
numeric partial water vapor pressure in Pascal (Pa)
}
\description{
calculate partial water vapor pressure \eqn{e} based on relative humdity and saturation water vapor pressure at temperature \eqn{t}
}
\examples{
\dontrun{
Es <- SVP(273.15)
WVP(70, Es)
}
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Center for Earth System Science, Tsinghua University
}
\seealso{
\code{\link{SVP}}, \code{\link{SVP.ClaCla}}, \code{\link{SVP.Murray}}.
}

