% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ping.R
\name{ping}
\alias{ping}
\title{Ping a url, doing a single call, with any http verbs}
\usage{
ping(url, verb = GET, ...)
}
\arguments{
\item{url}{A url}

\item{verb}{(character) An http verb, default: \code{\link[httr]{GET}}}

\item{...}{Any \code{httr} verb parameters passed on to those functions}
}
\description{
Ping a url, doing a single call, with any http verbs
}
\examples{
\dontrun{
"http://httpbin.org/get" \%>\% ping()
ping("http://httpbin.org/get")
"http://httpbin.org/get" \%>\% ping(config=verbose())
ping("http://httpbin.org/get", config=verbose())
"http://httpbin.org/get" \%>\% ping(config=c(verbose(), accept_json()))

"http://httpbin.org/get" \%>\% ping()
"http://httpbin.org/get" \%>\% ping(verb=HEAD)
"http://httpbin.org/get" \%>\% ping(verb=PUT)
"http://google.com" \%>\% ping()

# pass just a port number, tries to resolve, fails if not found
# "9200" \%>\% ping()
# 9200 \%>\% ping()
# 9200 \%>\% ping(verb=POST)
# 9200 \%>\% ping(verb=HEAD)
# ping(9200)
# ping("9200")
}
}

