% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_mass_functions.R
\name{skeletal_muscle_mass_children}
\alias{skeletal_muscle_mass_children}
\title{Predict skeletal muscle mass for children}
\usage{
skeletal_muscle_mass_children(gender, age_years)
}
\arguments{
\item{gender}{Vector of genders (either 'Male' or 'Female').}

\item{age_years}{Vector of ages in years.}
}
\value{
Vector of skeletal muscle masses in kg.
}
\description{
For individuals under age 18, predict skeletal muscle mass from gender and
age, using a nonlinear equation from Webber and Barr (2012)
}
\references{
Webber, Colin E., and Ronald D. Barr. "Age-and gender-dependent values of 
skeletal muscle mass in healthy children and adolescents." Journal of 
cachexia, sarcopenia and muscle 3.1 (2012): 25-29.

\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
