% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_httk.R
\name{convert_httk}
\alias{convert_httk}
\title{Converts HTTK-Pop virtual population into parameters relevant to an HTTK 
model.}
\usage{
convert_httk(indiv.model.bio, model, this.chem)
}
\arguments{
\item{indiv.model.bio}{A data.table containing the physiological
parameters as expected by HTTK (from \code{\link{httkpop_bio}}) and
\code{Funbound.plasma} and \code{Clint} values (from
\code{\link{draw_fup_clint}}).}

\item{model}{Which HTTK model to use. One of '1compartment', '3compartmentss',
'3compartment', or 'pbtk'.}

\item{this.chem}{CAS number for the chemical in the HTTK data set for which 
parameters are to be generated.}
}
\value{
A data.table whose columns are the parameters of the HTTK model 
 specified in \code{model}.
}
\description{
Converts HTTK-Pop virtual population into parameters relevant to an HTTK 
model.
}

