% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hte_forest.R
\name{hte_forest}
\alias{hte_forest}
\title{Estimate Heterogeneous Treatment Effect via Random Forest}
\usage{
hte_forest(
  outcomevariable,
  minsize = 20,
  crossvalidation = 20,
  data = edurose_mediation_20181126,
  treatment_indicator = "compcoll25",
  ps_indicator = "propsc_com25",
  ps_linear = "propsc_com25lin",
  covariates = c(linear_terms, ps_indicator),
  negative = FALSE,
  drawplot = TRUE,
  legend.x = 0.08,
  legend.y = 0.25,
  gf,
  ...
)
}
\arguments{
\item{outcomevariable}{a character representing the column name
of the outcome variable.}

\item{minsize}{the minimum number of observations in each leaf.
The default is set as 20.}

\item{crossvalidation}{number of cross validations. The default
is set as 20.}

\item{data}{a data frame containing the variables in the model.}

\item{treatment_indicator}{a character representing the column
name of the treatment indicator.}

\item{ps_indicator}{a character representing the column name of
the propensity score.}

\item{ps_linear}{a character representing name  of  a  column  that
stores  linearized  propensity scores.}

\item{covariates}{a vector of column names of all
covariates (linear terms andpropensity score).}

\item{negative}{a logical value indicating whether we expect the
treatment effect to be negative. The default is set as FALSE.}

\item{drawplot}{a logical value indicating whether to plot the
model as part of the output. The default is set as TRUE.}

\item{legend.x, legend.y}{x and y coordinate to position the legend.
The default is set as (0.08, 0.25).}

\item{gf}{a fitted generalized random forest object}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with three elements. The first one is the predicted outcome
for each unit. The second is an \code{causalTree} object with the tree split
information. The third is a \code{data.frame} summarizing the prediction
results.
}
\description{
Estimate heterogeneous treatment effect via random forest.
In each leaf, the treatment effect is the difference of mean outcome
weighted by inverse propensity scores in treatment group and
control group.
}
