% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kp_user_pw}
\alias{kp_user_pw}
\alias{login}
\alias{kp_user_email}
\alias{kp_password}
\alias{has_kp_user_and_pw}
\title{\strong{KenPom Login and Password credentials}}
\usage{
login(user_email = Sys.getenv("KP_USER"), user_pw = Sys.getenv("KP_PW"))

kp_user_email()

kp_password()

has_kp_user_and_pw()
}
\arguments{
\item{user_email}{User subscription e-mail}

\item{user_pw}{User subscription password}
}
\description{
Save your KenPom login e-mail and password as the system environment variables \code{KP_USER} and \code{KP_PW}

Requires a subscription to KenPom.com
}
\details{
\strong{Using your KenPom subscription with the package:} \cr

Run \href{https://usethis.r-lib.org/reference/edit.html}{\strong{\code{usethis::edit_r_environ()}}} and THEN paste the following in the new script that pops up (with\strong{out} quotations)\cr

\if{html}{\out{<div class="sourceCode r">}}\preformatted{KP_USER = YOUR-EMAIL@DOMAIN.COM
KP_PW = XXX-YOUR-PASSWORD-XXX
}\if{html}{\out{</div>}}

You can save the login information for consistent usage by adding \cr

\if{html}{\out{<div class="sourceCode">}}\preformatted{KP_USER = YOUR-EMAIL@DOMAIN.COM
KP_PW = XXX-YOUR-PASSWORD-XXX
``` \\cr
to your .REnviron file (easily accessed via [**`usethis::edit_r_environ()`**](https://usethis.r-lib.org/reference/edit.html)).\\cr
\\cr

For less consistent usage:\\cr
At the beginning of every session or within an R environment, save your login e-mail and password as the environment variables `KP_USER` and `KP_PW` (with quotations) using a command like the following.\\cr
```\{r\}
Sys.setenv(KP_USER = "YOUR-EMAIL@DOMAIN.COM")
Sys.setenv(KP_PW = "XXX-YOUR-PASSWORD-XXX")
}\if{html}{\out{</div>}}
}
\keyword{Login}
