% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{plot.fhmm}
\alias{plot.fhmm}
\title{Plotting functional Hidden Markov Models}
\usage{
\method{plot}{fhmm}(x, ...)
}
\arguments{
\item{x}{an object of class "\code{fhmm}", a result of a call to \code{fitBM_fhmm}}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
The function returns a plot of the centers representing the states of the Hidden Markov Model.
}
\description{
\code{plot} method for class "\code{fhmm}".
}
\examples{
\donttest{
data(simulatedFD)
n <- 20
n_tot <- 2000
bt <- seq(1,n_tot,by=n)
FD <- simulatedFD
hmm <- set_fhmm(FD, nStates = 3, bT=bt)
bw <- fitBM_fhmm(hmm)

plot(bw)}
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Hidden Markov Models for multivariate functional data, MOX Report 21/2019, 2019
}
\seealso{
\code{\link{fitBM_fhmm}}
}
