% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-09-14.R
\name{components}
\alias{components}
\title{Function to get the likelihood contribution of different rounding degrees}
\usage{
components(ki, kj, mean1_obs, mean2_obs, sigma1, sigma2, rho, y_obs,
  mean_y_precise, sd_y_precise, half_divisor)
}
\arguments{
\item{ki}{An integer for the i-th threshold (or "cutpoint")}

\item{kj}{An integer for the j-th threshold (or "cutpoint") (ki < kj)}

\item{mean1_obs}{A vector with the expected value of G for the observed data}

\item{mean2_obs}{A vector with the expected value of log(Y) for the observed data}

\item{sigma1}{A scalar for the variance of the G}

\item{sigma2}{A scalar for the variance of log(Y)}

\item{rho}{A scalar from [-1, 1] specifying the correlation between G and log(Y)}

\item{y_obs}{The vector of the target variable (with all NAs removed)}

\item{mean_y_precise}{A scalar specifying the mean of the target variable}

\item{sd_y_precise}{A scalar specifying the standard deviation of the target variable}

\item{half_divisor}{A scalar needed to find the bounds of possible rounding.
E.g. if rounding happens to the closest multiple of 500, the half.divisor is 250.}
}
\value{
A vector with the contribution to the likelihood of every individual with an observed target variable value
}
\description{
It is needed in the imputation routine for rounded income.
See equation (5) in Drechsler, Kiesl & Speidel (2015)
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions",
Austrian Journal of Statistics, Vol. 44, No. 2, \url{http://dx.doi.org/10.17713/ajs.v44i2.77}
}
