% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shadow_2d.R
\name{add_shadow_2d}
\alias{add_shadow_2d}
\title{Add shadow}
\usage{
add_shadow_2d(hillshade, shadowmap, max_darken = 0.7, rescale_original = FALSE)
}
\arguments{
\item{hillshade}{A 2D matrix of shadow intensities.}

\item{shadowmap}{A matrix that indicates the intensity of the shadow at that point. 0 is full darkness, 1 is full light.}

\item{max_darken}{Default '0.7'. The lower limit for how much the image will be darkened. 0 is completely black, 1 means the shadow map will have no effect.}

\item{rescale_original}{Ignored.}
}
\value{
A shaded map.
}
\description{
Multiplies a texture array or shadow map by a shadow map.
}
\examples{

library(rayshader)

# Create elevation matrix
el_mat <- raster_to_matrix(maungawhau)

el_mat \%>\%
 # Create hillshade layer using
 # ray-tracing
 ray_shade() \%>\%
 # Add ambient shading
 add_shadow_2d(
   ambient_shade(
     heightmap = el_mat
   )
 )

}
\author{
Slight modification from Tyler's code in \code{rayshader::add_shadow}
}
