% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leadLag.R
\name{leadLag}
\alias{leadLag}
\title{Lead-Lag estimation}
\usage{
leadLag(
  price1 = NULL,
  price2 = NULL,
  lags = NULL,
  resolution = "seconds",
  normalize = TRUE,
  parallelize = FALSE,
  nCores = NA
)
}
\arguments{
\item{price1}{xts or data.table containing prices in levels, in case of data.table,
use a column DT to denote the date-time in POSIXct format, and a column PRICE to denote the price}

\item{price2}{xts or data.table containing prices in levels, in case of data.table,
use a column DT to denote the date-time in POSIXct format, and a column PRICE to denote the price}

\item{lags}{a numeric denoting which lags (in units of \code{resolution}) should be tested as leading or lagging}

\item{resolution}{the resolution at which the lags is measured. 
The default is "seconds", use this argument to gain 1000 times resolution by setting it to either "ms", "milliseconds", or "milli-seconds".}

\item{normalize}{logical denoting whether the contrasts should be normalized by the product of the L2 norms of both the prices. Default = TRUE. 
This does not change the value of the lead-lag-ratio.}

\item{parallelize}{logical denoting whether to use a parallelized version of the C++ code (parallelized using OPENMP). Default = FALSE}

\item{nCores}{integer valued numeric denoting how many cores to use for the lead-lag estimation procedure in case parallelize is TRUE. 
Default is NA, which does not parallelize the code.}
}
\value{
An list with class "leadLag" which containing 'contrasts', 'lead-lag-ratio', and 'lags', denoting the estimated values for each lag calculated,
the lead-lag-ratio, and the tested lags respectively.
}
\description{
Function that estimates whether one series leads (or lags) another.
}
\details{
The lead-lag-ratio (LLR) can be used to see if one asset leads the other. If LLR < 1, then price1 MAY be leading price2 and vice versa if LLR > 1.
}
\examples{
ll <- leadLag(100 + cumsum(sbux), 100 + cumsum(lltc), lags = seq(-50,50))
plot(ll)

}
\references{
M. Hoffmann, M. Rosenbaum, and N. Yoshida (2013) : Estimation of the lead-lag parameter from non-synchronous data. Bernoulli 19, pages 1-37
}
