% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{estimate_skew_t}
\alias{estimate_skew_t}
\title{Estimate the parameters of skew-t distribution from multivariate observations}
\usage{
estimate_skew_t(
  X,
  initial = NULL,
  nu_lb = 9,
  max_iter = 100,
  ptol = 0.001,
  ftol = Inf,
  PXEM = TRUE,
  return_iterates = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{X}{Data matrix containing the multivariate time series (each column is one time series).}

\item{initial}{List of initial values of the parameters for the iterative estimation method.
Possible elements include:
\itemize{\item{\code{nu}: default is \code{4},}
         \item{\code{mu}: default is the data sample mean,}
         \item{\code{gamma}: default is the sample skewness vector,}
         \item{\code{scatter}: default follows from the scaled sample covariance matrix,}
         }}

\item{nu_lb}{Minimum value for the degree of freedom to maintain the existence of high-order moments (default is \code{9}).}

\item{max_iter}{Integer indicating the maximum number of iterations for the iterative estimation
method (default is \code{100}).}

\item{ptol}{Positive number indicating the relative tolerance for the change of the variables
to determine convergence of the iterative method (default is \code{1e-3}).}

\item{ftol}{Positive number indicating the relative tolerance for the change of the log-likelihood
value to determine convergence of the iterative method (default is \code{Inf}, so it is
not active). Note that using this argument might have a computational cost as a convergence
criterion due to the computation of the log-likelihood (especially when \code{X} is high-dimensional).}

\item{PXEM}{Logical value indicating whether to use the parameter expansion (PX) EM method to accelerating the convergence.}

\item{return_iterates}{Logical value indicating whether to record the values of the parameters (and possibly the
log-likelihood if \code{ftol < Inf}) at each iteration (default is \code{FALSE}).}

\item{verbose}{Logical value indicating whether to allow the function to print messages (default is \code{FALSE}).}
}
\value{
A list containing the following elements:
        \item{\code{mu}}{Location vector estimate (not the mean).}
        \item{\code{gamma}}{Skewness vector estimate.}
        \item{\code{scatter}}{Scatter matrix estimate.}
        \item{\code{nu}}{Degrees of freedom estimate.}
        \item{\code{chol_Sigma}}{Choleski decomposition of the Scatter matrix estimate.}
        \item{\code{a}}{A list of coefficients useful for later computation}
}
\description{
Using the package fitHeavyTail to estimate the parameters of ghMST distribution from multivariate observations, namely,
location vector (mu), skewness vector (gamma), scatter matrix (scatter), degree of freedom (nu), parameters a,
and the Cholesky decomposition of the scatter matrix (chol_Sigma).
}
\examples{
library(highOrderPortfolios)
data("X50")
X_skew_t_params <- estimate_skew_t(X50)

}
\references{
Aas, Kjersti and Ingrid Hobæk Haff. "The generalized hyperbolic skew student’st-distribution,"
Journal of financial econometrics, pp. 275-309, 2006.
}
\author{
Xiwen Wang, Rui Zhou, and Daniel P. Palomar
}
