% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/betas.R
\name{betas}
\alias{betas}
\title{Estimate \eqn{\beta}s per population and a bootstrap confidence interval}
\usage{
betas(dat,nboot=0,lim=c(0.025,0.975),diploid=TRUE)
}
\arguments{
\item{dat}{data frame with genetic data and pop identifier}

\item{nboot}{number of bootstrap samples}

\item{lim}{width of the bootstrap confidence interfal}

\item{diploid}{whether the data comes from a diploid organism}
}
\value{
betaiovl Average \eqn{\beta_i} over loci

ci The bootstrap confidence interval

Hi Within population gene diversities

Hb Between populations gene diversities
}
\description{
Estimate \eqn{\beta}s per population and a bootstrap confidence interval
}
\details{


Beware, only valid for non inbred diploids!
}
\examples{
dat<-sim.genot(size=100,N=c(100,1000,10000),nbloc=50,nbal=10)
betas(dat,nboot=100)$ci
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}

