\name{hhtransform}
\alias{hhtransform}
\title{Hilbert transform wrapper}
\description{
This function is a wrapper for the Hilbert transform functions included in the EMD package.
}
\usage{
hhtransform(imf_set)  
}
\arguments{
\item{imf_set}{A data structure returned by \code{\link{sig2imf}}, \code{\link{eemd}}, or \code{\link{eemd_resift}}.}
}
\details{
This function determines instantaneous amplitude and frequency from IMFs generated by the EMD method.
}
\value{ 
\item{hht_result}{The input data structure \code{imf_set}, but with fields \code{imf_set$hinstfreq} (frequency) and \code{imf_set$hamp} (amplitude).}
}
\references{
Huang, N. E., Shen, Z., Long, S. R., Wu, M. L. Shih, H. H.,
Zheng, Q., Yen, N. C., Tung, C. C. and Liu, H. H. (1998) The empirical
mode decomposition and Hilbert spectrum for nonlinear and
nonstationary time series analysis. \emph{Proceedings of the Royal
Society London A}, \bold{454}, 903--995.
}

\author{Daniel Bowman \email{daniel.bowman@unc.edu}}

\examples{
data(port_foster_event)

emd_config=list()
emd_config$max_sift=200
emd_config$max_imf=100
emd_config$tol=0.2
emd_config$stop_rule="type5"
emd_config$boundary="wave"
emd_config$sm="none"
emd_config$spar=NA
emd_config$weight=20
emd_config$S=5

#Run EMD (this may take some time)
emd_result=sig2imf(sig, dt, emd_config)

#Get instantaneous amplitude and frequency
emd_result=hhtransform(emd_result)

#Render spectrogram
max_freq=25
freq_step=0.05
hspec=hh_render(emd_result, max_freq, freq_step)

#Show result
time_span=c(5, 10)
freq_span=c(0, 25)
amp_span=c(0.000001, 0.00001)
hhspec_image(hspec, time_span, freq_span, amp_span)
}
\keyword{nonparametric}
