% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hfr.R
\name{hfr}
\alias{hfr}
\title{Fit a hierarchical feature regression}
\usage{
hfr(
  x,
  y,
  weights = NULL,
  kappa = 1,
  q = NULL,
  intercept = TRUE,
  standardize = TRUE,
  partial_method = c("pairwise", "shrinkage"),
  ...
)
}
\arguments{
\item{x}{Input matrix or data.frame, of dimension \eqn{(N\times p)}{(N x p)}; each row is an observation vector.}

\item{y}{Response variable.}

\item{weights}{an optional vector of weights to be used in the fitting process. Should be NULL or a numeric vector. If non-NULL, weighted least squares is used for the level-specific regressions.}

\item{kappa}{The target effective degrees of freedom of the regression as a percentage of \eqn{p}{p}.}

\item{q}{Thinning parameter representing the quantile cut-off (in terms of contributed variance) above which to consider levels in the hierarchy. This can used to reduce the number of levels in high-dimensional problems. Default is no thinning.}

\item{intercept}{Should intercept be fitted. Default is \code{intercept=TRUE}.}

\item{standardize}{Logical flag for x variable standardization prior to fitting the model. The coefficients are always returned on the original scale. Default is \code{standardize=TRUE}.}

\item{partial_method}{Indicate whether to use pairwise partial correlations, or shrinkage partial correlations.}

\item{...}{Additional arguments passed to \code{hclust}.}
}
\value{
An 'hfr' regression object.
}
\description{
HFR is a regularized regression estimator that decomposes a least squares
regression along a supervised hierarchical graph, and shrinks the edges of the
estimated graph to regularize parameters. The algorithm leads to group shrinkage in the
regression parameters and a reduction in the effective model degrees of freedom.
}
\details{
Shrinkage can be imposed by targeting an explicit effective degrees of freedom.
Setting the argument \code{kappa} to a value between \code{0} and \code{1} controls
the effective degrees of freedom of the fitted object as a percentage of \eqn{p}{p}.
When \eqn{p > N}{p > N} \code{kappa} is a percentage of \eqn{(N - 2)}{(N - 2)}.
If no \code{kappa} is set, a linear regression with \code{kappa = 1} is
estimated.

Hierarchical clustering is performed using \code{hclust}. The default is set to
ward.D2 clustering but can be overridden by passing a method argument to \code{...}.

For high-dimensional problems, the hierarchy becomes very large. Setting \code{q} to a value below 1
reduces the number of levels used in the hierarchy. \code{q} represents a quantile-cutoff of the amount of
variation contributed by the levels. The default (\code{q = NULL}) considers all levels.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = hfr(x, y, kappa = 0.5)
coef(fit)

}
\references{
Pfitzinger, J. (2022).
Cluster Regularization via a Hierarchical Feature Regression.
arXiv 2107.04831[statML]
}
\seealso{
\code{\link{cv.hfr}}, \code{\link{se.avg}}, \code{\link{coef}}, \code{\link{plot}} and \code{\link{predict}} methods
}
\author{
Johann Pfitzinger
}
