% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_fake_data.R
\name{make.linear.data}
\alias{make.linear.data}
\alias{make.quadradic.data}
\alias{make.skew.data}
\title{Generate dataset according to a linear model.}
\usage{
make.linear.data(n, gamma.vec = c(1, 2, 2, 1), gamma2.vec = NULL,
  beta.vec = c(-1, -1, 1), ideo.sd = 0, quad.tx = FALSE,
  mu.X = FALSE, corr.X = TRUE)

make.quadradic.data(n, beta.vec = c(-1, -1, 1))

make.skew.data(n, beta.vec = c(-1, -1, 1))
}
\arguments{
\item{n}{Sample size}

\item{gamma.vec}{Control outcome surface}

\item{gamma2.vec}{Quadratic terms}

\item{beta.vec}{Treatment effect surface}

\item{ideo.sd}{Ideosyncratic residual variation}

\item{quad.tx}{Quadratic treatment effects?}

\item{mu.X}{Center of the X covariates (can be single number or vector of length equal to the max of the length of gamma.vec, gamma2.vec, and beta.vec)}

\item{corr.X}{TRUE or FALSE.  Have Xs correlated or no.}
}
\value{
List of elements of data (not data frame)
}
\description{
Given the parameters, generate a dataset and return a potential outcomes schedule (science table)
of synthetic potential outcomes.
}
\details{
The control outcome surface is either linear or quadratic, of the form:
\deqn{Y_i = \\gamma_0 + \\sum_{k=1}^J \\gamma_k X_{ki} + \\sum_{k=1}^{J_2} \\gamma^{(2)}_k X_{ki}^2 + \\epsilon_i}

The individual treatment effects are similarly a linear or quadratic model.
}
\section{Functions}{
\itemize{
\item \code{make.quadradic.data}: Generate dataset according to a quadratic model

\item \code{make.skew.data}: Generate dataset with a skew
}}

\concept{data_generators}
