% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statevals.R
\name{create_StateVals}
\alias{create_StateVals}
\alias{create_StateVals.lm}
\alias{create_StateVals.stateval_tbl}
\title{Create \code{StateVals} object}
\usage{
create_StateVals(object, ...)

\method{create_StateVals}{lm}(object, input_data = NULL, n = 1000,
  point_estimate = FALSE, ...)

\method{create_StateVals}{stateval_tbl}(object, n = 1000, ...)
}
\arguments{
\item{object}{A model object of the appropriate class.}

\item{...}{Further arguments passed to or from other methods. Currently unused.}

\item{input_data}{An object of class "expanded_hesim_data" returned by 
\code{\link{expand.hesim_data}}. Must be expanded by the data tables "strategies",
"patients", and "states".}

\item{n}{Number of random observations of the parameters to draw when parameters 
are fit using a statistical model.}

\item{point_estimate}{If \code{TRUE}, then the point estimates are returned and and no samples are drawn.}
}
\value{
Returns an \code{\link{R6Class}} object of class \code{\link{StateVals}}.
}
\description{
\code{create_StateVals} is a generic function for creating an object of class
 \code{\link{StateVals}} from a fitted statistical model or a \code{\link{stateval_tbl}}
 object.
}
\seealso{
\code{\link{StateVals}}
}
