% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rh.seq.R
\name{rh.seq}
\alias{rh.seq}
\alias{rh_seq}
\alias{rhSeq}
\alias{RhSeq}
\title{Apply \code{rh} sequentially}
\usage{
rh.seq(x, a, transpose = FALSE)

rh_seq(x, a, transpose = FALSE)

rhSeq(x, a, transpose = FALSE)

RhSeq(x, a, transpose = FALSE)
}
\arguments{
\item{x}{A list of matrix-like objects}

\item{a}{A matrix-like object (with dimensions)}

\item{transpose}{A logical value.  The Default is
\code{FALSE}.  If \code{TRUE}, then the transpose of
\code{A}}
}
\value{
A \code{matrix} or \code{\link[Matrix]{Matrix-class}}.
}
\description{
\code{rh.seq} sequentially applies the \code{\link{rh}}
function to \code{a}.  Specifically, if the length of
\code{x} is \code{d}, then \code{rh.seq(x, a)} is
equivalent to \code{rh(x[[d]], rh(x[[d - 1]], ..., rh(x[[2]], rh(x[[1]], a))..))}.
}
\examples{
# generate x, a
x = list(matrix(rnorm(100), nrow = 10),
         matrix(rnorm(100), nrow = 10))
a = matrix(rnorm(100), nrow = 10)

# three equivalent forms
rhs1 = rh.seq(x, a)
rhs2 = rh(x[[2]], rh(x[[1]], a))
rhs3 = x[[1]] \%*\% a \%*\% t(x[[2]])

# check equality
all.equal(rhs1, rhs2)
all.equal(rhs1, rhs3)
}
