% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{bspline}
\alias{bspline}
\title{B-spline specification}
\usage{
bspline(rangeval = 0:1, nbasis, nknots, norder = 4, extend = FALSE, knots)
}
\arguments{
\item{rangeval}{A numeric vector of length 2 defining the
interval over which the functional data object can be
evaulated.  The default value is \code{0:1}.}

\item{nbasis}{An integer specifying the number of
basis functions to construct.  This is closely linked to
the number of knots (\code{nknots}), and
\code{nknots = nbasis - norder}.}

\item{nknots}{The number of *interior* knots.  See Details.}

\item{norder}{An integer specifying the order of the B-splines, which is one higher than their degree.  The default is 4, which corresponds to cubic splines.}

\item{extend}{Should the knots stop at the endpoints specified by \code{rangeval}?  Default is \code{FALSE}. See Details.}

\item{knots}{A numeric vector with all knots (interior
and exterior), including potentially replicated
endpoints.  See Details.}
}
\value{
An object of class \code{hero_bspline}.  It is a
  list specifying the necessary B-spline parameters.
}
\description{
\code{bspline} helps define the parameters necessary for
constructing a B-spline but doesn't evaluate it.
}
\details{
The knots are assumed to be equidistant and non-repeating
(except possibly at the endpoints).

The number of knots (\code{nknots}) and the number of
basis function (\code{nbasis}) are linked by the relation
\code{nknots = nbasis - norder}.

If \code{extend = TRUE},  the interior knots are
augmented by replicating the \code{rangeval} endpoints
\code{norder} times.  Otherwise, the interior knots are
augmented by \code{norder} knots at each end
corresponding to the spacing of the interior knots.

The knot placement mimics the behavior of
\code{\link[fda]{create.bspline.basis}} when \code{extend
= FALSE}. Note that the number of breaks specified by
\code{breaks} in \code{\link[fda]{create.bspline.basis}}
corresponds to the number of interior knots plus 2 (the
interior knots plus the two endpoints).

If \code{knots} is specified, the function does minimial
argument checking.  This is provided (mostly) for
testing purposes, though it can be used by individuals
who want more customizability of knots locations than
the equidistant spacing provided by default.
}
\examples{
bspline(nbasis = 10)
}
\seealso{
\code{\link{knot.design}}
}
\author{
Joshua French
}
