% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-date-columns.R
\name{add_date_columns}
\alias{add_date_columns}
\title{Add columns with date calculations based on reference date}
\usage{
add_date_columns(
  df,
  date_col,
  ref_date = Sys.Date(),
  fiscal_year_offset = 6,
  week_start = 1,
  drop = FALSE
)
}
\arguments{
\item{df}{data frame}

\item{date_col}{column with class of 'date'}

\item{ref_date}{reference date for calculations, defaults to current date}

\item{fiscal_year_offset}{the number of months to offset date, if fiscal
year ends in June, use 6}

\item{week_start}{integer for start of week where Monday = 1 and Sunday = 7}

\item{drop}{some of the generated fields may match the input data frame. When
TRUE, the original columns will be removed and replaced with the new field
of the same name. Otherwise, columns with the same name will be appended with
a '1'}
}
\value{
Returns a data frame with columns appended to describe
date distances from a reference date.
}
\description{
Using a reference date (defaults to current date), columns are
appended to the data set describing the number of days, weeks, months,
quarters, calendar years and fiscal years since the reference date. If
the new columns share names with an existing column, the function will show
a warning.
}
\examples{
demo_data() |>
  add_date_columns(date_col = date)

# if columns overlap, you will see a warning
demo_data() |>
  dplyr::mutate(week = 1) |>
  add_date_columns(date_col = date)

# to drop the old column and keep the new column use `drop = TRUE`
demo_data() |>
  dplyr::mutate(week = 1) |>
  add_date_columns(date_col = date, drop = TRUE)
}
