% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{createEngine}
\alias{createEngine}
\title{Create a Zigzag-HMC engine object}
\usage{
createEngine(
  dimension,
  lowerBounds,
  upperBounds,
  seed,
  mean,
  precision,
  flags = 128L,
  numThreads = 1L
)
}
\arguments{
\item{dimension}{the dimension of MTN.}

\item{lowerBounds}{a vector specifying the lower bounds.}

\item{upperBounds}{a vector specifying the upper bounds.}

\item{seed}{random seed.}

\item{mean}{the mean vector.}

\item{precision}{the precision matrix.}

\item{flags}{which SIMD instruction set to use. 128 = SSE, 256 = AVX.}

\item{numThreads}{number of threads for parallel execution (default = 1). Set to 0 for automatic detection of available cores.}
}
\value{
a list whose only element is the Zigzag-HMC engine object.
}
\description{
Create the C++ object to set up SIMD vectorization for speeding up calculations
for Zigzag-HMC ("Zigzag-HMC engine").
}
\examples{
# Create a 2D engine with simple bounds
dimension <- 2
lowerBounds <- c(-1, -1)
upperBounds <- c(1, 1)
mean <- c(0, 0)
precision <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
engine <- createEngine(dimension, lowerBounds, upperBounds, 
                       seed = 123, mean, precision, flags = 128)
# Check the engine structure
str(engine)
}
\seealso{
\code{\link[=setMean]{setMean()}}, \code{\link[=setPrecision]{setPrecision()}}, \code{\link[=zigzagHMC]{zigzagHMC()}}, \code{\link[=markovianZigzag]{markovianZigzag()}}
}
