% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rlassoEffects.R
\name{rlassoEffects}
\alias{rlassoEffect}
\alias{rlassoEffects}
\title{rigorous Lasso for Linear Models: Inference}
\usage{
rlassoEffects(x, y, index = c(1:ncol(x)), method = "partialling out",
  I3 = NULL, post = TRUE, ...)

rlassoEffect(x, y, d, method = "double selection", I3 = NULL, post = TRUE,
  ...)
}
\arguments{
\item{x}{matrix of regressor variables serving as controls and potential
treatments. For \code{rlassoEffect} it contains only controls, for \code{rlassoEffects} both controls and potential treatments. For \code{rlassoEffects} it must have at least two columns.}

\item{y}{outcome variable (vector or matrix)}

\item{index}{vector of integers, logicals or variables names indicating the position (column) of
variables (integer case), logical vector of length of the variables (TRUE or FALSE) or the variable names of \code{x} which should be used for inference / as treatment variables.}

\item{method}{method for inference, either 'partialling out' (default) or 'double selection'.}

\item{I3}{For the 'double selection'-method the logical vector \code{I3} has same length as the number of variables in \code{x};
indicates if variables (TRUE) should be included in any case to the model and they are exempt from selection. These variables should not be included in the \code{index}; hence the intersection with \code{index} must be the empty set.
In the case of partialling out it is ignored.}

\item{post}{logical, if post Lasso is conducted with default \code{TRUE}.}

\item{d}{variable for which inference is conducted (treatment variable)}

\item{\dots}{parameters passed to the \code{rlasso} function.}
}
\value{
The function returns an object of class \code{rlassoEffects} with the following entries: \item{coefficients}{vector with estimated
values of the coefficients for each selected variable} \item{se}{standard error (vector)}
\item{t}{t-statistic} \item{pval}{p-value} \item{samplesize}{sample size of the data set} \item{index}{index of the variables for which inference is performed}
}
\description{
Estimation and inference of (low-dimensional) target coefficients in a high-dimensional linear model.
}
\details{
The functions estimates (low-dimensional) target coefficients in a high-dimensional linear model.
An application is e.g. estimation of a treatment effect \eqn{\alpha_0} in a
setting of high-dimensional controls. The user can choose between the so-called post-double-selection method and partialling-out.
The idea of the double selection method is to select variables by Lasso regression of
the outcome variable on the control variables and the treatment variable on
the control variables. The final estimation is done by a regression of the
outcome on the treatment effect and the union of the selected variables in
the first two steps. In partialling-out first the effect of the regressors on the outcome and the treatment variable is taken out by Lasso and then a regression of the residuals is conducted. The resulting estimator for \eqn{\alpha_0} is normal
distributed which allows inference on the treatment effect. It presents a wrap function for \code{rlassoEffect}
which does inference for a single variable.
}
\examples{
library(hdm)
## DGP
n <- 250
p <- 100
px <- 10
X <- matrix(rnorm(n*p), ncol=p)
beta <- c(rep(2,px), rep(0,p-px))
intercept <- 1
y <- intercept + X \%*\% beta + rnorm(n)
## fit rlassoEffects object with inference on three variables
rlassoEffects.reg <- rlassoEffects(x=X, y=y, index=c(1,7,20))
## methods
summary(rlassoEffects.reg)
confint(rlassoEffects.reg, level=0.9)
}
\references{
A. Belloni, V. Chernozhukov, C. Hansen (2014). Inference on
treatment effects after selection among high-dimensional controls. The
Review of Economic Studies 81(2), 608-650.
}
\keyword{Estimation}
\keyword{High-dimensional}
\keyword{Inference}
\keyword{Treatment}
\keyword{controls}
\keyword{effect}

