% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_ext.R
\name{factor_ext}
\alias{factor_ext}
\title{Create an extended factor}
\usage{
factor_ext(x, values, levels, drop = FALSE)
}
\arguments{
\item{x}{The object to convert to an \code{factor_ext}}

\item{values}{The values used for the levels; This is were \code{factor_ext} is different from a
\code{factor}, as values for levels do not have to be consecutive or start at 1.}

\item{levels}{The levels of the object; character string}

\item{drop}{Should non-occurring levels be dropped}
}
\value{
An object of S3 class \code{factor_ext}
}
\description{
Create an extended factor
}
\details{
An extended version of a regular \code{factor} variable. Instead of the levels having values from
1 to n where n is the number of levels, any integer value can be used for any level (including 64bit integers). If
all values are in the range of a regular 32-bit integer, it is coerced to int. Automatic coercion of extended factors
to factors in \code{\link{H5ToR_Post}} for enums only works for 32-bit integer base types.
In this page this is heavily used, as constants in HDF5 can be arbitrary integer values.
}
\author{
Holger Hoefling
}
