% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPA.R
\name{catalogueSEPA}
\alias{catalogueSEPA}
\title{Data source: SEPA catalogue}
\usage{
catalogueSEPA()
}
\value{
This function returns a data frame containing the following columns:
\describe{
  \item{\code{SEPA_HYDROLOGY_OFFICE}}{}
  \item{\code{STATION_NAME}}{}
  \item{\code{LOCATION_CODE}}{Station id number.}
  \item{\code{NATIONAL_GRID_REFERENCE}}{}
  \item{\code{CATCHMENT_NAME}}{}
  \item{\code{RIVER_NAME}}{}
  \item{\code{GAUGE_DATUM}}{}
  \item{\code{CATCHMENT_AREA}}{in Km2}
  \item{\code{START_DATE}}{}
  \item{\code{END_DATE}}{}
  \item{\code{SYSTEM_ID}}{}
  \item{\code{LOWEST_VALUE}}{}
  \item{\code{LOW}}{}
  \item{\code{MAX_VALUE}}{}
  \item{\code{HIGH}}{}
  \item{\code{MAX_DISPLAY}}{}
  \item{\code{MEAN}}{}
  \item{\code{UNITS}}{}
  \item{\code{WEB_MESSAGE}}{}
  \item{\code{NRFA_LINK}}{}
}
}
\description{
This function provides the official SEPA database catalogue of
river level data
(from https://www2.sepa.org.uk/waterlevels/CSVs/SEPA_River_Levels_Web.csv)
containing info for hundreds of stations. Some are NRFA stations.
The function has no input arguments.
}
\examples{
\dontrun{
  # Retrieve the whole catalogue
  SEPA_catalogue_all <- catalogueSEPA()
}

}
\author{
Claudia Vitolo
}
