% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KGClimateClass.R
\name{KGClimateClass}
\alias{KGClimateClass}
\title{Function to identify the updated Koppen-Greiger climate zone (on a 0.1 x 0.1 degrees resolution map).}
\usage{
KGClimateClass(areaBox = NULL, updatedBy = "Peel", verbose = FALSE)
}
\arguments{
\item{areaBox}{bounding box, a list made of 4 elements: minimum longitude (lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum latitude (latMax)}

\item{updatedBy}{this can either be "Kottek" or "Peel"}

\item{verbose}{if TRUE more info are printed on the screen}
}
\value{
List of overlapping climate zones.
}
\description{
Given a bounding box, the function identifies the overlapping climate zones.
}
\examples{
\dontrun{
  # Define a bounding box
  areaBox <- raster::extent(-3.82, -3.63, 52.41, 52.52)
  # Get climate classes
  KGClimateClass(areaBox = areaBox)
}

}
\author{
Claudia Vitolo
}
\references{
Kottek et al. (2006): \url{http://koeppen-geiger.vu-wien.ac.at/}. Peel et al. (2007): \url{http://people.eng.unimelb.edu.au/mpeel/koppen.html}.
}

