% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{get.factor.model}
\alias{get.factor.model}
\title{Factor model estimation via Principal Component Analysis}
\usage{
get.factor.model(
  z,
  r.max = NULL,
  ic = c("ah", "bn")[1],
  ic.op = 2,
  normalisation = TRUE
)
}
\arguments{
\item{z}{input data matrix, with each row representing the component time series}

\item{r.max}{maximum allowed number of factors}

\item{ic}{estimator for the factor number; \code{if(ic=='ah')} eigenvalue ratio estimator of Ahn and Horenstein (2013) is used, \code{if(ic=='bn')} information criterion estimator of Bai and Ng (2002) is used}

\item{ic.op}{type of the estimator specified by \code{ic}}

\item{normalisation}{\code{if(normalisation==TRUE)} rows of \code{z} are normalised prior to factor analysis}
}
\value{
a list containing
  \item{eigvec}{eigenvectors of \code{z}}
  \item{eigval}{eigenvalues of \code{z}}
  \item{norm.x}{row-wise normalised \code{z} \code{if(normalisation==TRUE)}}
  \item{r.hat}{estimated number of factors}
  \item{r.max}{maximum number of factors used}
  \item{ic.eval}{vector containing information criterion evaluated at \code{r = 0, 1, ..., r.max}}
  \item{mean}{row-wise means of \code{z}}
  \item{sd}{row-wise standard deviations of \code{z}}
  \item{ic}{input \code{ic}}
  \item{ic.op}{input \code{ic.op}}
}
\description{
Estimates the components of the factor structure for an input time series, such as loadings and factors, as well as estimating the number of factors.
}
\references{
S. C. Ahn and A. R. Horenstein (2013) Eigenvalue ratio test for the number of factors. \emph{Econometrica}, vol. 81, pp. 1203--1227.
J. Bai and S. Ng (2002) Determining the number of factors in approximate factor models. \emph{Econometrica}, vol. 70, pp. 191--221.
}
\keyword{internal}
