% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_arima.R
\name{hanr_arima}
\alias{hanr_arima}
\title{Anomaly detector using ARIMA.}
\usage{
hanr_arima()
}
\value{
\code{hanr_arima} object
}
\description{
Anomaly detection using ARIMA
The ARIMA model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the ARIMA model presented in the forecast library.
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 1
dataset <- har_examples$example1
head(dataset)

# setting up time series regression model
model <- hanr_arima()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection |> dplyr::filter(event==TRUE))

}
