% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layers_metadata.R
\name{get_layers_metadata}
\alias{get_layers_metadata}
\title{Metadata for one couple of apikey and data_type}
\usage{
get_layers_metadata(apikey, data_type)
}
\arguments{
\item{apikey}{API key from \code{get_apikeys()} or directly
from the \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{data_type}{Should be \code{"wfs"} or \code{"wms"}. See details for more
information about these two Webservice formats.}
}
\value{
data.frame
}
\description{
Metadata are retrieved using the IGN APIs. The execution time can
be long depending on the size of the metadata associated with
the API key and the overload of the IGN servers.
}
\examples{
\dontrun{
apikey <- get_apikeys()[4]
metadata_table <- get_layers_metadata(apikey, "wms")
layers <- metadata_table$Name
one_abstract <- metadata_table[1, "Abstract"]

# List every wfs layers (warning : it's quite long)
all_layers <- lapply(get_apikeys(),
                     get_layers_metadata,
                     data_type = "wfs")

# Convert list to data.frame
all_layers <- do.call(rbind, list_metadata)
}

}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}
}
