% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_commune.R
\name{get_apicarto_commune}
\alias{get_apicarto_commune}
\title{Apicarto Commune}
\usage{
get_apicarto_commune(x,
                     source = "PCI")
}
\arguments{
\item{x}{It can be a shape, insee code or departement code.
\itemize{
\item shape : it must be an object of class \code{sf} or \code{sfc}.
\item insee or departement code : it must be an object of class \code{character}. All insee code
from France can be retrieved by running \code{data(cog_2022)}
}}

\item{source}{Can be "BDP" for BD Parcellaire or "PCI" for Parcellaire
express. The BD Parcellaire is a discontinued product. Its use is no longer
recommended because it is no longer updated. The use of PCI Express is
strongly recommended and will become mandatory. More information on the
comparison of this two products can be found
\href{https://geoservices.ign.fr/sites/default/files/2021-07/Comparatif_PEPCI_BDPARCELLAIRE.pdf}{here}}
}
\value{
\code{get_apicarto_commune}return an object of class \code{sf}
}
\description{
Implementation of the cadastre module of the
\href{https://apicarto.ign.fr/api/doc/cadastre}{IGN's apicarto} for commune borders
}
\examples{
\dontrun{
library(sf)
library(tmap)

# Using shape
line <- st_linestring(matrix(c(-4.372215, -4.365177, 47.803943, 47.79772),
                             ncol = 2))
line <- st_sfc(line, crs = st_crs(4326))

commune <- get_apicarto_commune(line)

tm_shape(commune)+
   tm_borders()+
tm_shape(line)+
   tm_lines(col = "red", lwd = 2)

# Using code_insee
commune <- get_apicarto_commune("29158")

tm_shape(commune)+
   tm_borders()+
   tm_text("nom_com")

# Get multiple communes borders

input <- list(line, "29171")
borders <- lapply(input, get_apicarto_commune, source = "PCI")
borders <- do.call(rbind, borders)

tm_shape(borders)+
   tm_borders()+
   tm_text("nom_com")
}

}
