% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_divisions.R
\name{commons_divisions}
\alias{commons_divisions}
\alias{hansard_commons_divisions}
\title{House of Commons divisions}
\usage{
commons_divisions(division_id = NULL, division_uin = NULL,
  summary = FALSE, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)

hansard_commons_divisions(division_id = NULL, division_uin = NULL,
  summary = FALSE, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)
}
\arguments{
\item{division_id}{The id of a particular vote. If empty, returns a
tibble with information on all commons divisions, subject to all other
parameters. Defaults to \code{NULL}. Only accepts a single division ID
at a time, but to return details on a list of division IDs use with
\code{lapply}. The \code{division_id} takes priority over the \code{division_uid} parameter.}

\item{division_uin}{The UIN of a particular vote. If empty, returns a
tibble with information on all commons divisions, subject to all other
parameters. Defaults to \code{NULL}. Only accepts a single division UIN
at a time, but to return details on a list of division UINs use with
\code{lapply}.}

\item{summary}{If \code{TRUE}, returns a small tibble summarising a
division outcome. Otherwise returns a tibble with details on how each
MP voted. Has no effect if \code{division_id} is empty. Defaults to \code{FALSE}.}

\item{start_date}{Only includes divisions on or after this date. Accepts
character values in \code{'YYYY-MM-DD'} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything
else that can be coerced to a date with \code{as.Date()}. Defaults
to \code{'1900-01-01'}.}

\item{end_date}{Only includes divisions on or before this date. Accepts
character values in \code{'YYYY-MM-DD'} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything
else that can be coerced to a date with \code{as.Date()}. Defaults to
the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with the results of divisions in the House of Commons.
}
\description{
Imports data on House of Commons divisions (votes), either full details
on how each member voted, or a summary of vote totals.
}
\examples{
\dontrun{

## All commons divisions
x <- commons_divisions()

## Vote breakdown of specific commons division
y <- commons_divisions(division_id = 694163, summary = FALSE)
}

}
