% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/members.R
\name{members}
\alias{members}
\alias{hansard_members}
\alias{commons_members}
\alias{hansard_commons_members}
\alias{lords_members}
\alias{hansard_lords_members}
\title{Imports data on all current and former Members of Parliament including the Lords and the Commons}
\usage{
members(ID = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_members(ID = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

commons_members(extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")

hansard_commons_members(extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

lords_members(extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")

hansard_lords_members(extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{ID}{The ID of a member of the House of Commons or the House of Lords. Defaults to NULL. If NULL, returns a tibble of all members. If not NULL, returns a tibble with basic information on that member.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with data on members of the House of Commons and/or the House of Lords.
}
\description{
Imports data on all current and former Members of Parliament including the Lords and the Commons

Imports data on all current and former MPs

Imports data on all current and former peers
}
\examples{
\dontrun{
x <- members(172)

x <- commons_members()

x <- lords_members()

x <- lords_interests(530)
}
}
\seealso{
\code{\link{members_search}}
}
\keyword{All}
\keyword{Members}
\keyword{Parliament}
\keyword{of}
