% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handl_to_df.R
\name{handl_to_df}
\alias{handl_to_df}
\title{handl to data.frame conversion}
\usage{
handl_to_df(x)
}
\arguments{
\item{x}{an object of class handl}
}
\value{
data.frame with column following \link{handl}, with as many rows
as there are citations
}
\description{
handl to data.frame conversion
}
\note{
requires the Suggested package \code{data.table}
}
\examples{
z <- system.file('extdata/crossref.ris', package = "handlr")
res <- ris_reader(z)
handl_to_df(res)

(x <- HandlrClient$new(x = z))
x$as_df() # empty data.frame
x$read()
x$as_df() # data.frame with citation data

(z <- system.file('extdata/bib-many.bib', package = "handlr"))
res2 <- bibtex_reader(x = z)
handl_to_df(res2)
}
