% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvc_readutils.R
\name{cvc_to_raw_cf}
\alias{cvc_to_raw_cf}
\title{Convert correlation function read from CVC HDF5 or AFF format to 'raw_cf'}
\usage{
cvc_to_raw_cf(cf_dat, dims = c(1, 1))
}
\arguments{
\item{cf_dat}{Numeric vector of alternating real and imaginary parts of a
correlation function. Ordering of the input should be complex, internal dimensions,
time (left to right, fastest to slowest).}

\item{dims}{Integer vector with the sizes of the internal dimensions. For example,
\code{c(4,4)} for spin correlators.}
}
\value{
\code{raw_cf} object with a \code{data} member which contains the data (as complex numbers)
in the shape \code{c(1,nts,dims)}, where \code{nts} is the number of time slices
inferred from the length of \code{cfdat} and the product of the internal dimensions \code{dims}.
}
\description{
Given a numeric vector of alternating real and imaginary parts of a
correlation function, creates an object of class 'raw_cf' with
a single measurement, inferring \code{Time} from the passed numeric vector
while the shape of the internal dimensions has to be specified explicitly
if larger than \verb{one by one} (\code{c(1,1)}).
}
