/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_igt_pvl_delta_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_igt_pvl_delta");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_igt_pvl_delta");
    reader.add_event(146, 131, "end", "model_igt_pvl_delta");
    return reader;
}

#include <meta_header.hpp>
 class model_igt_pvl_delta : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > outcome;
    vector_d initV;
public:
    model_igt_pvl_delta(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_igt_pvl_delta(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_igt_pvl_delta_namespace::model_igt_pvl_delta";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("outcome");
            pos__ = 0;
            size_t outcome_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
                size_t outcome_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                    outcome[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            current_statement_begin__ = 21;
            // initialize data variables
            current_statement_begin__ = 24;
            validate_non_negative_index("initV", "4", 4);
            initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
            stan::math::fill(initV,DUMMY_VAR__);

            current_statement_begin__ = 25;
            stan::math::assign(initV, rep_vector(0.0,4));

            // validate transformed data
            current_statement_begin__ = 24;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 30;
            validate_non_negative_index("mu_pr", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 31;
            validate_non_negative_index("sigma", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 34;
            validate_non_negative_index("A_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 35;
            validate_non_negative_index("alpha_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 36;
            validate_non_negative_index("cons_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 37;
            validate_non_negative_index("lambda_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_igt_pvl_delta() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "4", 4);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(4));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "4", 4);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("A_pr")))
            throw std::runtime_error("variable A_pr missing");
        vals_r__ = context__.vals_r("A_pr");
        pos__ = 0U;
        validate_non_negative_index("A_pr", "N", N);
        context__.validate_dims("initialization", "A_pr", "vector_d", context__.to_vec(N));
        vector_d A_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            A_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_pr", "N", N);
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("cons_pr")))
            throw std::runtime_error("variable cons_pr missing");
        vals_r__ = context__.vals_r("cons_pr");
        pos__ = 0U;
        validate_non_negative_index("cons_pr", "N", N);
        context__.validate_dims("initialization", "cons_pr", "vector_d", context__.to_vec(N));
        vector_d cons_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            cons_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(cons_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cons_pr: ") + e.what());
        }

        if (!(context__.contains_r("lambda_pr")))
            throw std::runtime_error("variable lambda_pr missing");
        vals_r__ = context__.vals_r("lambda_pr");
        pos__ = 0U;
        validate_non_negative_index("lambda_pr", "N", N);
        context__.validate_dims("initialization", "lambda_pr", "vector_d", context__.to_vec(N));
        vector_d lambda_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(4,lp__);
            else
                mu_pr = in__.vector_constrain(4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,4,lp__);
            else
                sigma = in__.vector_lb_constrain(0,4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  A_pr;
            (void) A_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                A_pr = in__.vector_constrain(N,lp__);
            else
                A_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pr;
            (void) alpha_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_pr = in__.vector_constrain(N,lp__);
            else
                alpha_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  cons_pr;
            (void) cons_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                cons_pr = in__.vector_constrain(N,lp__);
            else
                cons_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda_pr;
            (void) lambda_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_pr = in__.vector_constrain(N,lp__);
            else
                lambda_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 41;
            validate_non_negative_index("A", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
            (void) A;  // dummy to suppress unused var warning

            stan::math::initialize(A, DUMMY_VAR__);
            stan::math::fill(A,DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("cons", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  cons(static_cast<Eigen::VectorXd::Index>(N));
            (void) cons;  // dummy to suppress unused var warning

            stan::math::initialize(cons, DUMMY_VAR__);
            stan::math::fill(cons,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("lambda", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
            (void) lambda;  // dummy to suppress unused var warning

            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 46;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 47;
                stan::model::assign(A, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))), 
                            "assigning variable A");
                current_statement_begin__ = 48;
                stan::model::assign(alpha, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2), 
                            "assigning variable alpha");
                current_statement_begin__ = 49;
                stan::model::assign(cons, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5), 
                            "assigning variable cons");
                current_statement_begin__ = 50;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(A(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: A" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(cons(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cons" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(lambda(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"A",A,0);
            check_less_or_equal(function__,"A",A,1);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"alpha",alpha,0);
            check_less_or_equal(function__,"alpha",alpha,2);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"cons",cons,0);
            check_less_or_equal(function__,"cons",cons,5);
            current_statement_begin__ = 44;
            check_greater_or_equal(function__,"lambda",lambda,0);
            check_less_or_equal(function__,"lambda",lambda,10);

            // model body

            current_statement_begin__ = 55;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 59;
            lp_accum__.add(normal_log<propto__>(A_pr, 0, 1));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(cons_pr, 0, 1));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(lambda_pr, 0, 1));
            current_statement_begin__ = 64;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 66;
                validate_non_negative_index("ev", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(4));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);
                current_statement_begin__ = 67;
                local_scalar_t__ curUtil;
                (void) curUtil;  // dummy to suppress unused var warning

                stan::math::initialize(curUtil, DUMMY_VAR__);
                stan::math::fill(curUtil,DUMMY_VAR__);
                current_statement_begin__ = 68;
                local_scalar_t__ theta;
                (void) theta;  // dummy to suppress unused var warning

                stan::math::initialize(theta, DUMMY_VAR__);
                stan::math::fill(theta,DUMMY_VAR__);


                current_statement_begin__ = 71;
                stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                current_statement_begin__ = 72;
                stan::math::assign(ev, initV);
                current_statement_begin__ = 74;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 76;
                    lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), multiply(theta,ev)));
                    current_statement_begin__ = 78;
                    if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                        current_statement_begin__ = 79;
                        stan::math::assign(curUtil, pow(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),get_base1(alpha,i,"alpha",1)));
                    } else {

                        current_statement_begin__ = 81;
                        stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)),get_base1(alpha,i,"alpha",1))));
                    }
                    current_statement_begin__ = 85;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), "ev") + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)))), 
                                "assigning variable ev");
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("A_pr");
        names__.push_back("alpha_pr");
        names__.push_back("cons_pr");
        names__.push_back("lambda_pr");
        names__.push_back("A");
        names__.push_back("alpha");
        names__.push_back("cons");
        names__.push_back("lambda");
        names__.push_back("mu_A");
        names__.push_back("mu_alpha");
        names__.push_back("mu_cons");
        names__.push_back("mu_lambda");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_igt_pvl_delta_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d A_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d cons_pr = in__.vector_constrain(N);
        vector_d lambda_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 41;
            validate_non_negative_index("A", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
            (void) A;  // dummy to suppress unused var warning

            stan::math::initialize(A, DUMMY_VAR__);
            stan::math::fill(A,DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("cons", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  cons(static_cast<Eigen::VectorXd::Index>(N));
            (void) cons;  // dummy to suppress unused var warning

            stan::math::initialize(cons, DUMMY_VAR__);
            stan::math::fill(cons,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("lambda", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
            (void) lambda;  // dummy to suppress unused var warning

            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 46;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 47;
                stan::model::assign(A, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))), 
                            "assigning variable A");
                current_statement_begin__ = 48;
                stan::model::assign(alpha, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2), 
                            "assigning variable alpha");
                current_statement_begin__ = 49;
                stan::model::assign(cons, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5), 
                            "assigning variable cons");
                current_statement_begin__ = 50;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"A",A,0);
            check_less_or_equal(function__,"A",A,1);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"alpha",alpha,0);
            check_less_or_equal(function__,"alpha",alpha,2);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"cons",cons,0);
            check_less_or_equal(function__,"cons",cons,5);
            current_statement_begin__ = 44;
            check_greater_or_equal(function__,"lambda",lambda,0);
            check_less_or_equal(function__,"lambda",lambda,10);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 91;
            local_scalar_t__ mu_A;
            (void) mu_A;  // dummy to suppress unused var warning

            stan::math::initialize(mu_A, DUMMY_VAR__);
            stan::math::fill(mu_A,DUMMY_VAR__);
            current_statement_begin__ = 92;
            local_scalar_t__ mu_alpha;
            (void) mu_alpha;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha, DUMMY_VAR__);
            stan::math::fill(mu_alpha,DUMMY_VAR__);
            current_statement_begin__ = 93;
            local_scalar_t__ mu_cons;
            (void) mu_cons;  // dummy to suppress unused var warning

            stan::math::initialize(mu_cons, DUMMY_VAR__);
            stan::math::fill(mu_cons,DUMMY_VAR__);
            current_statement_begin__ = 94;
            local_scalar_t__ mu_lambda;
            (void) mu_lambda;  // dummy to suppress unused var warning

            stan::math::initialize(mu_lambda, DUMMY_VAR__);
            stan::math::fill(mu_lambda,DUMMY_VAR__);
            current_statement_begin__ = 97;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 100;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 103;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 104;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 105;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 109;
            stan::math::assign(mu_A, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 110;
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_pr,2,"mu_pr",1)) * 2));
            current_statement_begin__ = 111;
            stan::math::assign(mu_cons, (Phi_approx(get_base1(mu_pr,3,"mu_pr",1)) * 5));
            current_statement_begin__ = 112;
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_pr,4,"mu_pr",1)) * 10));

            current_statement_begin__ = 115;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 117;
                validate_non_negative_index("ev", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(4));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);
                current_statement_begin__ = 118;
                local_scalar_t__ curUtil;
                (void) curUtil;  // dummy to suppress unused var warning

                stan::math::initialize(curUtil, DUMMY_VAR__);
                stan::math::fill(curUtil,DUMMY_VAR__);
                current_statement_begin__ = 119;
                local_scalar_t__ theta;
                (void) theta;  // dummy to suppress unused var warning

                stan::math::initialize(theta, DUMMY_VAR__);
                stan::math::fill(theta,DUMMY_VAR__);


                current_statement_begin__ = 122;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 123;
                stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                current_statement_begin__ = 124;
                stan::math::assign(ev, initV);
                current_statement_begin__ = 126;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 128;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + categorical_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),multiply(theta,ev))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 131;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                categorical_rng(softmax(multiply(theta,ev)), base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 133;
                    if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                        current_statement_begin__ = 134;
                        stan::math::assign(curUtil, pow(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),get_base1(alpha,i,"alpha",1)));
                    } else {

                        current_statement_begin__ = 136;
                        stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)),get_base1(alpha,i,"alpha",1))));
                    }
                    current_statement_begin__ = 140;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), "ev") + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)))), 
                                "assigning variable ev");
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 91;
            check_greater_or_equal(function__,"mu_A",mu_A,0);
            check_less_or_equal(function__,"mu_A",mu_A,1);
            current_statement_begin__ = 92;
            check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
            check_less_or_equal(function__,"mu_alpha",mu_alpha,2);
            current_statement_begin__ = 93;
            check_greater_or_equal(function__,"mu_cons",mu_cons,0);
            check_less_or_equal(function__,"mu_cons",mu_cons,5);
            current_statement_begin__ = 94;
            check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
            check_less_or_equal(function__,"mu_lambda",mu_lambda,10);
            current_statement_begin__ = 97;
            current_statement_begin__ = 100;

            // write generated quantities
        vars__.push_back(mu_A);
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_cons);
        vars__.push_back(mu_lambda);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_igt_pvl_delta";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cons" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cons" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_igt_pvl_delta_namespace::model_igt_pvl_delta stan_model;


#endif
