% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CommonFG.R
\docType{class}
\name{CommonFG}
\alias{CommonFG}
\alias{CommonFG-class}
\alias{[,CommonFG,character,ANY-method}
\alias{[<-,CommonFG,character,ANY-method}
\alias{h5close}
\alias{h5unlink}
\alias{h5unlink,CommonFG,character-method}
\title{The CommonFG Class}
\usage{
h5close(.Object)

\S4method{[}{CommonFG,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CommonFG,character,ANY}(x, i, j, ...) <- value

h5unlink(.Object, path)

\S4method{h5unlink}{CommonFG,character}(.Object, path)
}
\arguments{
\item{.Object}{CommonFG; S4 object of class \code{CommonFG};}

\item{x}{CommonFG; object to be subsetted}

\item{i}{character; Name of \code{\link{H5Group}}}

\item{j}{character; Name of \code{\link{DataSet}}}

\item{...}{Additional arguments passed to \code{\link{createDataSet}}; only
relevant for assignment operator.}

\item{drop}{logical; specify if class of result set should be dropped (not
implemented yet).}

\item{value}{vector/matrix/array; Value to be assigend to dataset}

\item{path}{character; Path to be deleted, either specifying group or dataset.}
}
\description{
\code{CommonFG} is the base class of \code{\link{H5File}} and \code{\link{H5Group}}
and represents common  functionality of these two classes. The CommonFG base
class supports various subsetting operators to easily access and manipulate
\code{\link{H5Group}} and \code{\link{DataSet}} objects
(see also \code{\link{CommonFG-Group}} and \code{\link{CommonFG-DataSet}}).
}
\details{
Subsetting operators on \code{CommonFG} objects represent a convenient way
to create/access \code{\link{H5Group}} and \code{\link{DataSet}} objects.
Currently, only character arguments are supported whereas the first argument
specifies the group to be created/accesses and the second the dataset name.

Groups can be created/accessed by simply using one character parameter, e.g.
\code{group <- obj["groupname"]}.

DataSets can be either accessed by using
\code{dset <- obj["groupname", "datasetname"]} if existing or initialized by
using \code{obj["groupname", "datasetname"] <- value}.

All created objects e.g. \code{group} or \code{dset} should be closed in the
end using \code{h5close}.
}
\examples{
file <- h5file("test.h5")
# Create new DataSet 'testset' in H5Group 'testgroup'
file["testgroup/testset"] <- matrix(1:9, nrow = 3)
# Create new DataSet 'testset2' in file root
file["testset2"] <- 1:10
# Retrieve H5Group 'testgroup'
group <- file["testgroup"]
# Retrieve DataSet 'testset'
dset <- group["testset"]
h5close(dset)
h5close(group)
h5close(file)
file.remove("test.h5")
}
\seealso{
\code{\link{CommonFG-Group}} \code{\link{CommonFG-DataSet}}
\code{\link{H5Location-Attribute}}
}

