% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unidirectional_edges.R
\name{get_udedge}
\alias{get_udedge}
\title{Get a unidirectional edge index}
\usage{
get_udedge(origin = NULL, destination = NULL, simple = TRUE)
}
\arguments{
\item{origin}{Character; 15-character cell index generated by H3. A vector of
indexes can also be supplied.}

\item{destination}{Character; 15-character cell index generated by H3. A vector
of indexes can also be supplied.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, character vector of unidirectional edge indexes.
}
\description{
Returns an H3 index representing a unidirectional edge for a given origin and
destination cell pair.
}
\note{
The number of cell indexes supplied to origin and destination must be
  equal.
}
\examples{
# Return the unidirectional edge representing the transition between these two cells:
get_udedge(origin = '86be8d12fffffff', destination = '86be8d127ffffff')

}
