% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.R
\name{h2o.import_sql_table}
\alias{h2o.import_sql_table}
\title{Import SQL Table into H2O}
\usage{
h2o.import_sql_table(connection_url, table, username, password,
  columns = NULL, optimize = NULL)
}
\arguments{
\item{connection_url}{URL of the SQL database connection as specified by the Java Database Connectivity (JDBC) Driver.
For example, "jdbc:mysql://localhost:3306/menagerie?&useSSL=false"}

\item{table}{Name of SQL table}

\item{username}{Username for SQL server}

\item{password}{Password for SQL server}

\item{columns}{(Optional) Character vector of column names to import from SQL table. Default is to import all columns.}

\item{optimize}{(Optional) Optimize import of SQL table for faster imports. Experimental. Default is true.}
}
\description{
Imports SQL table into an H2O cloud. Assumes that the SQL table is not being updated and is stable.
Runs multiple SELECT SQL queries concurrently for parallel ingestion.
Be sure to start the h2o.jar in the terminal with your downloaded JDBC driver in the classpath:
   `java -cp <path_to_h2o_jar>:<path_to_jdbc_driver_jar> water.H2OApp`
Also see h2o.import_sql_select.
Currently supported SQL databases are MySQL, PostgreSQL, and MariaDB. Support for Oracle 12g and Microsoft SQL Server
}
\details{
For example,
   my_sql_conn_url <- "jdbc:mysql://172.16.2.178:3306/ingestSQL?&useSSL=false"
   table <- "citibike20k"
   username <- "root"
   password <- "abc123"
   my_citibike_data <- h2o.import_sql_table(my_sql_conn_url, table, username, password)
}

